-- Fichero FIRSTins.sql
------------------------------------------------------------------
-- Creacin de FIRST: Creacin de las tablas de la Base de      --
-- Metaconocimiento Difuso (FMB).                               --
-- Estas tablas deben ser del DBA, Administrador de la base de  --
-- datos (SYS) y los usuarios autorizados a utilizar dicha base --
-- de datos tendrn los siguientes permisos sobre esas tablas:  --
--   SELECT: Para poder efectuar consultas a la base de datos   --
--           difusa (en FSQL) y sobre dicha base de datos.      --
--   INSERT: Los usuarios con este permiso podrn declarar      --
--           nuevos atributos difusos, nuevas etiquetas...      --
--   UPDATE: Con este permiso los usuarios podrn actualizar    --
--           los valores de la FMB: Alterar etiquetas...        --
--           Debe ser otorgado a usuarios experimentados        --
--           de confianza.                                      --
--   DELETE: Con este permiso los usuarios podrn borrar        --
--           los valores de la FMB: Borrar etiquetas...         --
--           Debe ser otorgado a usuarios experimentados        --
--           de confianza.                                      --
------------------------------------------------------------------

-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> **************************************** <<<<');
exec dbms_output.put_line('>>>> **** INSTALACIN de FIRST: Tablas   **** <<<<');
exec dbms_output.put_line('>>>> **** de la Base de Metaconocimiento **** <<<<');
exec dbms_output.put_line('>>>> **** Difuso (FMB), sinnimos...     **** <<<<');
exec dbms_output.put_line('>>>> **************************************** <<<<');
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> NOTAS:');
exec dbms_output.put_line('>>>>   - No importa si se producen errores al intentar borrar objetos');
exec dbms_output.put_line('>>>>     que no existan (tablas ORA-00942...).');
exec dbms_output.put_line('>>>>   - Cualquier otro error podr impedir la correcta ejecucin del Servidor FSQL.');
exec dbms_output.put_line('>>>>     En ese caso revise el cdigo del error y el lugar donde ha ocurrido.');
exec dbms_output.put_line('>>>>');

exec dbms_output.put_line('>>>> Borrando y Creando tablas de FMB...');
-- Tabla con las columnas que admiten tratamiento difuso
DROP   TABLE FUZZY_COL_LIST CASCADE CONSTRAINTS;
CREATE TABLE FUZZY_COL_LIST(
  OBJ#   NUMBER NOT NULL,
  COL#   NUMBER NOT NULL,
  F_TYPE NUMBER(1) NOT NULL,
  LEN    NUMBER(2) NOT NULL,
  COM    VARCHAR2(100),
  PRIMARY KEY (OBJ#,COL#),
  CONSTRAINT LEN_TOO_LONG_IN_FUZZY_COL_LIST
             CHECK (LEN>=1 AND LEN<=10),
  CONSTRAINT FUZZY_TYPE_MUST_BE_1_2_o_3
             CHECK (F_TYPE=1 OR F_TYPE=2 OR F_TYPE=3));
--*CAMPOS
-- OBJ#	OBJECT_ID de la tabla (obtenido de USER_OBJECTS)
-- COL#	COLUMN_ID del campo (obtenido de USER_TAB_COLUMNS)
-- F_TYPE	Tipo de tratamiento difuso para ese campo (1, 2  3)
-- LEN	Nmero de datos mximo en atributos tipo 3
--		Suponemos que no hay ms de 10 datos (y 1 como mnimo)
-- COM	Comentario breve (nombre de la tabla y columna)

-- Objetos difusos de las columnas de la base de datos
DROP   TABLE FUZZY_OBJECT_LIST CASCADE CONSTRAINTS;
CREATE TABLE FUZZY_OBJECT_LIST(
  OBJ# NUMBER NOT NULL,
  COL# NUMBER NOT NULL,
  FUZZY_ID NUMBER(3)      NOT NULL, -- Suponemos no ms de 1000 objetos por cada atributo
  FUZZY_NAME VARCHAR2(30) NOT NULL,
  FUZZY_TYPE NUMBER(1)    NOT NULL,
  PRIMARY KEY (OBJ#,COL#,FUZZY_ID),
  CONSTRAINT FK_OBJ#_COL#_FOL FOREIGN KEY (OBJ#,COL#)
             REFERENCES FUZZY_COL_LIST (OBJ#,COL#) ON DELETE CASCADE,
  CONSTRAINT NO_SPACES_IN_FUZZY_NAME
             CHECK (FUZZY_NAME NOT LIKE '% %'));
--*CAMPOS
-- OBJ#/COL#	OBJECT_ID y COLUMN_ID
-- FUZZY_ID		Identificador del objeto difuso. Llave externa en:
--			FUZZY_LABEL_DEF, FUZZY_NEARNESS_DEF y FUZZY_QUALIFIERS_DEF
-- FUZZY_NAME	Nombre del objeto difuso
-- FUZZY_TYPE	Tipo de objeto:
--	0	Etiqueta trapezoidal (Ir a FLD)
--	1	Escalares con relaciones de semejanza (Ir a FND)
--	2	Cualificadores (Ir a FQD)			
--	3	Etiquetas sobre cuantificadores relativos (Ir a FQND)
--	4	Etiquetas sobre cuantificadores absolutos (Ir a FLD)

-- Trapecios asociados a las etiquetas
DROP   TABLE FUZZY_LABEL_DEF;
CREATE TABLE FUZZY_LABEL_DEF(
  OBJ# NUMBER NOT NULL,
  COL# NUMBER NOT NULL,
  FUZZY_ID NUMBER(3) NOT NULL, -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
  ALFA  NUMBER NOT NULL,
  BETA  NUMBER NOT NULL,
  GAMMA NUMBER NOT NULL,
  DELTA NUMBER NOT NULL,
  PRIMARY KEY (OBJ#,COL#,FUZZY_ID),
  CONSTRAINT FK_OBJ#_COL#_FUZZY_ID_FLD FOREIGN KEY (OBJ#,COL#,FUZZY_ID)
    REFERENCES FUZZY_OBJECT_LIST (OBJ#,COL#,FUZZY_ID) ON DELETE CASCADE,
  CONSTRAINT MUST_BE_ORDERED
             CHECK (ALFA<=BETA AND BETA<=GAMMA AND GAMMA<=DELTA));
--*CAMPOS
-- OBJ#/COL#	OBJECT_ID y COLUMN_ID
-- FUZZY_ID		Identificador del objeto difuso (FUZZY_TYPE=0  4 en FOL)
-- [ALFA,BETA,GAMMA,DELTA]	Datos del trapecio donde ALFA<=BETA<=GAMMA<=DELTA

-- Semejanza entre los escalares de los atributos tipo 3
DROP   TABLE FUZZY_NEARNESS_DEF;
CREATE TABLE FUZZY_NEARNESS_DEF(
  OBJ# NUMBER NOT NULL,
  COL# NUMBER NOT NULL,
  FUZZY_ID1 NUMBER(3) NOT NULL, -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
  FUZZY_ID2 NUMBER(3) NOT NULL, -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
  DEGREE NUMBER (3,2) NOT NULL,
  PRIMARY KEY (OBJ#,COL#,FUZZY_ID1,FUZZY_ID2),
  CONSTRAINT FK_OBJ#_COL#_FUZZY_ID1_FND FOREIGN KEY (OBJ#,COL#,FUZZY_ID1)
    REFERENCES FUZZY_OBJECT_LIST (OBJ#,COL#,FUZZY_ID) ON DELETE CASCADE,
  CONSTRAINT FK_OBJ#_COL#_FUZZY_ID2_FND FOREIGN KEY (OBJ#,COL#,FUZZY_ID2)
    REFERENCES FUZZY_OBJECT_LIST (OBJ#,COL#,FUZZY_ID) ON DELETE CASCADE,
  CONSTRAINT FUZZY_ID1_IGUAL_QUE_FUZZY_ID2
             CHECK (FUZZY_ID1<>FUZZY_ID2),
  CONSTRAINT FUZZY_ID1_MAYOR_QUE_FUZZY_ID2
             CHECK (FUZZY_ID1<FUZZY_ID2),
  CONSTRAINT DEGREE_MUST_BE_IN_0_1_INTERVAL
             CHECK (DEGREE>=0 AND DEGREE<=1));
-- OBJ#/COL#	OBJECT_ID y COLUMN_ID
-- FUZZY_ID1 y 2	Identificadores de dos objetos difusos (FUZZY_TYPE=1 en FOL)
-- DEGREE		Valor en [0,1]: Semejanza entre los dos objetos

-- Almacena dos valores para atributos tipo 1 y 2:
--	1) Margen por defecto para los valores APROX: #n = nMARGEN
--	   Se usar al insertar valores APROX, si no se indica otro margen
--	2) Diferencia mnima entre 2 valores de ese atributo, para poder afirmar
--	   que uno es MUCHO MAYOR o MUCHO MENOR que el otro:
--	   Comparadores MGT (Much Greater Than) y MLT (Much Less Than).
-- Por razones semnticas y para evitar confusiones en el orden,
-- se exige que MARGEN sea menor que MUCH.
DROP   TABLE FUZZY_APPROX_MUCH;
CREATE TABLE FUZZY_APPROX_MUCH(
  OBJ#   NUMBER NOT NULL,
  COL#   NUMBER NOT NULL,
  MARGEN NUMBER NOT NULL,
  MUCH   NUMBER NOT NULL,
  PRIMARY KEY (OBJ#,COL#),
  CONSTRAINT FK_OBJ#_COL#_FAM FOREIGN KEY (OBJ#,COL#)
             REFERENCES FUZZY_COL_LIST (OBJ#,COL#) ON DELETE CASCADE,
  CONSTRAINT MARGEN_LESS_THAN_MUCH_IN_FAM
             CHECK (MARGEN<MUCH));

-- Definicin del cualificador (MIN) asociado al valor
-- de FUZZY_OBJECT_LIST (FUZZY_ID): Opcin no implementada an en el Servidor FSQL
--DROP   TABLE FUZZY_QUALIFIERS_DEF;
--CREATE TABLE FUZZY_QUALIFIERS_DEF(
--  OBJ# NUMBER NOT NULL,
--  COL# NUMBER NOT NULL,
--  FUZZY_ID NUMBER(3) NOT NULL, -- FUZZY_OBJECT_LIST.FUZZY_ID%TYPE
--  MIN NUMBER NOT NULL,
--  PRIMARY KEY (OBJ#,COL#,FUZZY_ID),
--  CONSTRAINT FK_OBJ#_COL#_FQD FOREIGN KEY (OBJ#,COL#)
--             REFERENCES FUZZY_COL_LIST (OBJ#,COL#) ON DELETE CASCADE);

-- Definicin de columnas tipo 3 que son compatibles unas con otras.
DROP   TABLE FUZZY_COMPATIBLE_COL;
CREATE TABLE FUZZY_COMPATIBLE_COL(
  OBJ#1 NUMBER NOT NULL,
  COL#1 NUMBER NOT NULL,
  OBJ#2 NUMBER NOT NULL,
  COL#2 NUMBER NOT NULL,
  PRIMARY KEY (OBJ#1,COL#1),
  CONSTRAINT FK_OBJ#1_COL#1_FCC FOREIGN KEY (OBJ#1,COL#1)
             REFERENCES FUZZY_COL_LIST (OBJ#,COL#) ON DELETE CASCADE,
  CONSTRAINT FK_OBJ#2_COL#2_FCC FOREIGN KEY (OBJ#2,COL#2)
             REFERENCES FUZZY_COL_LIST (OBJ#,COL#) ON DELETE CASCADE);
--*CAMPOS
-- OBJ#1/COL#1	OBJECT_ID y COLUMN_ID de una columna tipo 3 compatible con la siguiente
--            	y sin etiquetas definidas sobre ella. Las etiquetas las toma de la siguiente.
-- OBJ#2/COL#2	OBJECT_ID y COLUMN_ID de una columna tipo 3 con etiquetas definidas sobre
--            	ella en FUZZY_NEARNESS_DEF

exec dbms_output.put_line('>>>> Borrando y Creando sinnimos pblicos de las tablas de FMB...');
DROP PUBLIC SYNONYM FCL;
DROP PUBLIC SYNONYM FOL;
DROP PUBLIC SYNONYM FLD;
DROP PUBLIC SYNONYM FND;
DROP PUBLIC SYNONYM FAM;
DROP PUBLIC SYNONYM FCC;
--DROP PUBLIC SYNONYM FQD;
CREATE PUBLIC SYNONYM FCL FOR FUZZY_COL_LIST;
CREATE PUBLIC SYNONYM FOL FOR FUZZY_OBJECT_LIST;
CREATE PUBLIC SYNONYM FLD FOR FUZZY_LABEL_DEF;
CREATE PUBLIC SYNONYM FND FOR FUZZY_NEARNESS_DEF;
CREATE PUBLIC SYNONYM FAM FOR FUZZY_APPROX_MUCH;
CREATE PUBLIC SYNONYM FCC FOR FUZZY_COMPATIBLE_COL;
--CREATE PUBLIC SYNONYM FQD FOR FUZZY_QUALIFIERS_DEF;

exec dbms_output.put_line('>>>> Concediendo permisos a PUBLIC...');
GRANT SELECT,INSERT,DELETE,UPDATE on FCL to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FOL to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FLD to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FND to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FAM to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FCC to PUBLIC;
--GRANT SELECT,INSERT,DELETE,UPDATE on FQD to PUBLIC;

exec dbms_output.put_line('>>>> Insertando comentarios sobre las tablas de la FMB...');
-- Comentarios sobre las tablas de la FMB
comment on table FUZZY_COL_LIST is
'Columnas que son susceptibles de tratamiento difuso';
comment on table FUZZY_OBJECT_LIST is
'Objectos definidos en columnas difusas para su tratamiento';
comment on table FUZZY_LABEL_DEF is
'Definicin de etiquetas difusas trapezoidales';
comment on table FUZZY_NEARNESS_DEF is
'Semejanza entre los valores de los atributos tipo 3';
comment on table FUZZY_APPROX_MUCH is
'Margen m por defecto de los valores aproximados (N  m) y distancia mnima para el MGT/MLT';
comment on table FUZZY_COMPATIBLE_COL is
'Columnas difusas tipo 3 compatibles (comparables entre s)';
--comment on table FUZZY_QUALIFIERS_DEF is
--'Definicin del cualificador asociado a un valor lingustico';

exec dbms_output.put_line('>>>> Crear vistas para simplificar algunas consultas:');
exec dbms_output.put_line('>>>> Vista ALL_COMPATIBLES_T3: Consulta de Atributos Difusos Tipo 3 compatibles...');
-- Vista para simplificar la consulta de Atributos Difusos Tipo 3 compatibles
create or replace view ALL_COMPATIBLES_T3 AS
  SELECT distinct FCL1.COM Columna_1, FCL1.LEN Length_1, FCL2.COM Compatible_Con_Columna_2, FCL2.LEN Length_2
  FROM FCL FCL1, FCL FCL2, FCC
  WHERE FCL1.OBJ#=FCC.OBJ#1 AND FCL2.OBJ#=FCC.OBJ#2 AND
        FCL1.COL#=FCC.COL#1 AND FCL2.COL#=FCC.COL#2;
-- Otra forma mejor, pero con problemas de memoria:
--create or replace view ALL_COMPATIBLES_T3 AS
--  SELECT O1.OWNER || O1.TABLE_NAME || C1.COLUMN_NAME Columna_1,
--  O2.OWNER || O2.TABLE_NAME || C2.COLUMN_NAME Compatible_Con_Columna_2
--  FROM FCC, ACCESSIBLE_TABLES O1, ALL_TAB_COLUMNS C1, ACCESSIBLE_TABLES O2, ALL_TAB_COLUMNS C2
--  WHERE O1.OBJ#=FCC.OBJ#1 AND O2.OBJ#=FCC.OBJ#2 AND
--        C1.COLUMN_ID=FCC.COL#1 AND C2.COLUMN_ID=FCC.COL#2;
DROP   PUBLIC SYNONYM ACT3;
CREATE PUBLIC SYNONYM ACT3 FOR ALL_COMPATIBLES_T3;
GRANT SELECT on ACT3 to PUBLIC;
comment on table ALL_COMPATIBLES_T3 is
'Atributos Difusos Tipo 3 compatibles entre s: El primero, compatible con el segundo';

exec dbms_output.put_line('>>>> Vista LABELS_FOR_OBJCOL: Consulta de las distintas etiquetas de una columna...');
-- Vista par facilitar la consulta de las distintas etiquetas de una columna.
-- Ejemplo: Para ver las etiquetas y su definicin de un atributo con
-- OBJ=XXX y COL=YYY: Select label, alfa,beta,gamma,delta from lfoc where obj#=XXX and col#=YYY
create or replace view LABELS_FOR_OBJCOL AS
  SELECT FOL.OBJ# OBJ#, FOL.COL# COL#, Fuzzy_Name Label, Alfa, Beta, Gamma, Delta
  FROM FOL, FLD
  WHERE FOL.OBJ#=FLD.OBJ# AND FLD.FUZZY_ID=FOL.FUZZY_ID AND
        FOL.COL#=FLD.COL# AND FOL.FUZZY_TYPE=0;
DROP   PUBLIC SYNONYM LFOC;
CREATE PUBLIC SYNONYM LFOC FOR LABELS_FOR_OBJCOL;
GRANT SELECT on LFOC to PUBLIC;
comment on table LABELS_FOR_OBJCOL is
'Etiquetas definidas para atributos tipo 1 y 2.';

exec dbms_output.put_line('>>>> Vista LABELS_OBJCOL_T3: Consulta de las etiquetas de una columna Tipo 3...');
-- Vista par facilitar la consulta de las etiquetas de una columna Tipo 3.
-- Se muestra tambin el grado de similitud entre estas etiquetas
create or replace view LABELS_OBJCOL_T3 AS
 SELECT FND.OBJ# OBJ#, FND.COL# COL#, FOL1.FUZZY_NAME Label_1, FOL2.FUZZY_NAME Label_2, DEGREE
 FROM FOL FOL1, FOL FOL2, FND
 WHERE FOL1.OBJ#=FOL2.OBJ# AND FOL1.COL#=FOL2.COL# AND
       FOL1.OBJ#=FND.OBJ#  AND FOL1.COL#=FND.COL#  AND
       FOL1.FUZZY_TYPE=1   AND FOL2.FUZZY_TYPE=1   AND
       FND.FUZZY_ID1=FOL1.FUZZY_ID AND FND.FUZZY_ID2=FOL2.FUZZY_ID;
DROP   PUBLIC SYNONYM LOCT3;
CREATE PUBLIC SYNONYM LOCT3 FOR LABELS_OBJCOL_T3;
GRANT SELECT on LOCT3 to PUBLIC;
comment on table LABELS_OBJCOL_T3 is
'Etiquetas definidas para atributos tipo 3 y su grado de similitud entre ellas.';

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la INSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
